<?php 

namespace Redtree\EnetClient\Resources\Network\Electricity;

use Redtree\EnetClient\Client;
use Redtree\EnetClient\Exceptions\MissingAttributesException;

class NetworkMeasuringPrices
{
    /**
     * Available fields for request.
     *
     * @var array
     */
    protected $fieldsNetworknumber = [
        'networknumber',
        'voltage_level',
        'metertype',
    ];
    
    /**
     * Available fields for request.
     *
     * @var array
     */
    protected $fieldsWONetworknumber = [
        'postcode',
        'city',
        'street',
        'house_number',
        'voltage_level',
        'metertype',
    ];
    
    /**
     * Check if all required fields are filled.
     *
     * @param array $data Data to Compare.
     * @throws Redtree\EnetClient\Exceptions\MissingAttributesException
     * @return bool
     */
    public static function compare(array $data):bool
    {
        $instance = new static();
        $failed = $instance->validate($data);
        if ($failed) {
            throw new MissingAttributesException("Not all required fields filled. Fields:".PHP_EOL. implode("," . PHP_EOL, $instance->availableFields()));
        }
        return true;
    }
    
    /**
     * @return array
     */
    public static function availableFields()
    {
        return (new static())->getFields();
    }
    
    /**
     * Check if all required fields are filled.
     *
     * @param array $data Data to Compare.
     * @return bool
     */
    public function validate($data):bool
    {
        $missing = [];
        if (array_key_exists('networknumber', $data)) {
            foreach ($this->fieldsNetworknumber as $key) {
                if (!array_key_exists($key, $data)) {
                    array_push($missing, $key);
                    continue;
                };
            }
        } else {
            foreach ($this->fieldsWONetworknumber as $key) {
                if (!array_key_exists($key, $data)) {
                    array_push($missing, $key);
                    continue;
                };
            }
        }

        return !empty($missing);
    }
    
    
    /**
     * Return all required fields
     *
     * @return array
     */
    public function getFields()
    {
        return $this->fieldsNetworknumber;
    }
}
