<?php 

namespace Redtree\EnetClient\Resources\Network\Electricity;

use Redtree\EnetClient\Client;
use Redtree\EnetClient\Exceptions\MissingAttributesException;

class NetworkNumber
{
    /**
     * Available fields for request.
     *
     * @var array
     */
    protected $fields = [
        'postcode',
        'city',
        'street',
        'house_number',
        'voltage_level',
        
    ];
    
    /**
     * Check if all required fields are filled.
     *
     * @param array $data Data to Compare.
     * @throws Redtree\EnetClient\Exceptions\MissingAttributesException
     * @return bool
     */
    public static function compare(array $data):bool
    {
        $instance = new static();
        $failed = $instance->validate($data);
        if ($failed) {
            throw new MissingAttributesException("Not all required fields filled. Fields:".PHP_EOL. implode(",".PHP_EOL, $instance->availableFields()));
        }
        return true;
    }
    
    /**
     * @return array
     */
    public static function availableFields()
    {
        return (new static())->getFields();
    }
    
    /**
     * Check if all required fields are filled.
     *
     * @param array $data Data to Compare.
     * @return bool
     */
    public function validate($data):bool
    {
        $missing = [];
        foreach ($this->fields as $key) {
            if (!array_key_exists($key, $data)) {
                array_push($missing, $key);
                continue;
            };
        }
        
        return !empty($missing);
    }
    
    
    /**
     * Return all required fields
     *
     * @return array
     */
    public function getFields()
    {
        return $this->fields;
    }
}
