<?php

namespace Redtree\FeatureFlags\Models\System;

use App\Models\System\Tenant;
use App\Models\Tenant\Permission;
use App\Models\Tenant\Role;
use App\Traits\UsesSystemConnection;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Feature extends Model
{
    use UsesSystemConnection;

    protected $fillable = [
        'key',
        'apps',
        'is_core',
        'is_active',
        'is_payment_required',
        'name',
        'description',
        'status',
    ];

    protected $casts = [
        'apps' => 'array',
        'is_core' => 'bool',
        'is_active' => 'bool',
        'is_payment_required' => 'bool',
    ];

    public function tenants(): BelongsToMany
    {
        return $this->belongsToMany(Tenant::class)->withPivot(['is_active']);
    }

    public function roles(): HasMany
    {
        return $this->hasMany(Role::class);
    }

    public function permissions(): HasMany
    {
        return $this->hasMany(Permission::class);
    }

    public function scopeisActive(Builder $builder): Builder
    {
        return $builder->where(function (Builder $builder) {
            $builder
                ->where('is_active', true)
                ->orWhere('is_core', true);
        });
    }
}
