<?php

namespace Redtree\FeatureFlags\Traits;

use Exception;
use Illuminate\Support\Str;

trait BaseFeature
{
    /** @throws Exception */
    public function getKey(): string
    {
        if (property_exists($this, 'key')) {
            return $this->key;
        }

        return Str::camel(class_basename($this));
    }
}
