<?php

namespace Redtree\FileLibrary\Conversions\Actions;

use Redtree\FileLibrary\Conversions\Conversion;
use Redtree\FileLibrary\Conversions\Events\ConversionHasBeenCompleted;
use Redtree\FileLibrary\Conversions\Events\ConversionWillStart;
use Redtree\FileLibrary\Conversions\ImageGenerators\ImageGeneratorFactory;
use Redtree\FileLibrary\Media\Filesystem;
use Redtree\FileLibrary\Media\Models\Media;

class PerformConversionAction
{
    public function execute(Conversion $conversion, Media $media, string $copiedOriginalFile)
    {
        event(new ConversionWillStart($media, $conversion, $copiedOriginalFile));

        $copiedOriginalFile = ImageGeneratorFactory::forMedia($media)->convert($copiedOriginalFile, $conversion);

        $manipulationResult = (new PerformManipulationsAction())->execute($media, $conversion, $copiedOriginalFile);

        $newFileName = $conversion->getConversionFile($media);

        $renamedFile = $this->renameInLocalDirectory($manipulationResult, $newFileName);

        app(Filesystem::class)->copyToMediaLibrary($renamedFile, $media, 'conversions');

        $media->markAsConversionGenerated($conversion->getName());

        event(new ConversionHasBeenCompleted($media, $conversion));
    }

    protected function renameInLocalDirectory(string $fileNameWithDirectory, string $newFileNameWithoutDirectory): string
    {
        $targetFile = pathinfo($fileNameWithDirectory, PATHINFO_DIRNAME) . '/' . $newFileNameWithoutDirectory;

        rename($fileNameWithDirectory, $targetFile);

        return $targetFile;
    }
}
