<?php

namespace Redtree\FileLibrary\Media;

use Closure;
use Illuminate\Support\Arr;
use Redtree\FileLibrary\HasMedia;
use Redtree\FileLibrary\Media\Models\Collections\MediaCollection;
use Redtree\FileLibrary\Media\Models\Media;

class MediaRepository
{
    public function getCollection(HasMedia $model, string $collectionName, $filter = []): MediaCollection
    {
        return $this->applyFilterToMediaCollection($model->loadMedia($collectionName), $filter);
    }

    protected function applyFilterToMediaCollection(MediaCollection $media, $filter): MediaCollection
    {
        if (is_array($filter)) {
            $filter = $this->getDefaultFilterFunction($filter);
        }

        return $media->filter($filter);
    }

    protected function getDefaultFilterFunction(array $filters): Closure
    {
        return function (Media $media) use ($filters) {
            foreach ($filters as $property => $value) {
                if (! Arr::has($media->custom_properties, $property)) {
                    return false;
                }

                if (Arr::get($media->custom_properties, $property) !== $value) {
                    return false;
                }
            }

            return true;
        };
    }
}
