<?php

namespace Redtree\FileLibrary\Support;

use Illuminate\Support\Str;
use Spatie\TemporaryDirectory\TemporaryDirectory as BaseTemporaryDirectory;

class TemporaryDirectory
{
    public static function create(): BaseTemporaryDirectory
    {
        return new BaseTemporaryDirectory(self::getTemporaryDirectoryPath());
    }

    protected static function getTemporaryDirectoryPath(): string
    {
        $path = config('file-library.temporary_directory_path') ?? storage_path('file-library/temp');

        return $path . DIRECTORY_SEPARATOR . Str::random(32);
    }
}
