<?php

namespace Redtree\FileLibrary\Media;

use Redtree\FileLibrary\Conversions\ConversionCollection;
use Redtree\FileLibrary\Conversions\ImageGenerators\Image;
use Redtree\FileLibrary\Media\Models\Media;

class HtmlableMedia
{
    protected Media $media;

    protected string $conversionName = '';

    protected array $extraAttributes = [];

    protected string $loadingAttributeValue = '';

    public function __construct(Media $media)
    {
        $this->media = $media;
    }

    public function attributes(array $attributes): self
    {
        $this->extraAttributes = $attributes;

        return $this;
    }

    public function conversion(?string $conversionName): self
    {
        $this->conversionName = $conversionName;

        return $this;
    }

    public function lazy(): self
    {
        $this->loadingAttributeValue = ('lazy');

        return $this;
    }

    public function toHtml(): string
    {
        if (! (new Image())->canHandleMime($this->media->mime_type)) {
            return '';
        }

        $attributeString = collect($this->extraAttributes)
            ->map(fn ($value, $name) => $name . '="' . $value . '"')->implode(' ');

        if (strlen($attributeString)) {
            $attributeString = ' ' . $attributeString;
        }

        $loadingAttributeValue = config('file-library.default_loading_attribute_value');

        if ($this->conversionName !== '') {
            $conversionObject = ConversionCollection::createForMedia($this->media)->getByName($this->conversionName);

            $loadingAttributeValue = $conversionObject->getLoadingAttributeValue();
        }

        if ($this->loadingAttributeValue !== '') {
            $loadingAttributeValue = $this->loadingAttributeValue;
        }

        $width = '';
        $height = '';

        $media = $this->media;
        $conversion = $this->conversionName;

        return view('file-library::image', compact('media', 'conversion', 'attributeString', 'loadingAttributeValue', 'width', 'height'))
            ->render();
    }

    public function __toString()
    {
        return $this->toHtml();
    }
}
