<?php

namespace Redtree\FileLibrary\Support;

use Redtree\FileLibrary\Media\Models\Media;

class PathGenerator
{
    public function getPath(Media $media): string
    {
        return $this->getBasePath($media) . '/';
    }

    public function getPathForConversions(Media $media): string
    {
        return $this->getBasePath($media) . '/conversions/';
    }

    protected function getBasePath(Media $media): string
    {
        $prefix = config('file-library.prefix', '');

        if ($prefix !== '') {
            return $prefix . '/' . $media->getKey();
        }

        return $media->getKey();
    }
}
