<?php

namespace Redtree\FileLibrary;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class FileLibraryServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/file-library.php', 'file-library');
    }

    public function boot(): void
    {
        $this->registerPublishes();

        $this->loadViewsFrom(__DIR__ . '/../resources/views', 'file-library');

        Route::get('media/{mediaUuid}/{conversion?}', [config('file-library.media_controller'), 'media'])->name('media')->middleware(config('file-library.middleware_group', ''));
    }

    public function registerPublishes(): void
    {
        $this->publishes([
            __DIR__ . '/../config/file-library.php' => config_path('file-library.php'),
        ], 'config');

        $this->publishes([
            __DIR__ . '/../database/migrations/create_media_files_table.php.stub' => database_path(sprintf('migrations/%s_create_media_files_table.php', now()->format('Y_m_d_His'))),
            __DIR__ . '/../database/migrations/create_tenant_media_files_table.php.stub' => database_path(sprintf('migrations/tenant/%s_create_media_files_table.php', now()->format('Y_m_d_His'))),
        ], 'migrations');
    }
}
