<?php

namespace Redtree\FileLibrary\Media;

use Illuminate\Support\Facades\Storage;
use Redtree\FileLibrary\Conversions\ConversionCollection;
use Redtree\FileLibrary\Exceptions\InvalidConversion;
use Redtree\FileLibrary\Media\Models\Media;
use Redtree\FileLibrary\Support\PathGenerator;

class File
{
    public string $name;

    public int $size;

    public string $mimeType;

    public string $path = '';

    public function __construct(string $name, int $size, string $mimeType, string $path = '')
    {
        $this->name = $name;
        $this->size = $size;
        $this->mimeType = $mimeType;
        $this->path = $path;
    }

    /**
     * @throws InvalidConversion
     */
    public static function createFromMedia(Media $media, string $conversionName = ''): self
    {
        if ($conversionName !== '') {
            $conversion = ConversionCollection::createForMedia($media)->getByName($conversionName);
            $storage = Storage::disk($media->disk);
            $conversionFileName = $conversion->getConversionFile($media);
            $path = app(PathGenerator::class)->getPathForConversions($media) . $conversionFileName;

            return new self($conversionFileName, $storage->size($path), $storage->mimeType($path), $path);
        }

        return new self($media->file_name, $media->size, $media->mime_type);
    }

    public function __toString(): string
    {
        return "name: $this->name, size: $this->size, mime: $this->mimeType";
    }
}
