<?php

namespace Redtree\FileLibrary\Media\Models\Collections;

use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Database\Eloquent\Collection;
use Redtree\FileLibrary\Media\Models\Media;

class MediaCollection extends Collection implements Htmlable
{
    public ?string $collectionName = null;

    public function collectionName(string $collectionName): self
    {
        $this->collectionName = $collectionName;

        return $this;
    }

    public function totalSizeInBytes(): int
    {
        return $this->sum('size');
    }

    public function toArray()
    {
        if ($this->collectionName === null) {
            return [];
        }

        return old($this->collectionName) ?? $this->map(fn (Media $media) => $this->mediaData($media))->keyBy('uuid');
    }

    public function toHtml(): string
    {
        return e(json_encode(old($this->collectionName) ?? $this->map(fn (Media $media) => $this->mediaData($media))->keyBy('uuid')));
    }

    public function jsonSerialize(): array
    {
        if ($this->collectionName === null) {
            return [];
        }

        return old($this->collectionName) ?? $this->map(fn (Media $media) => $this->mediaData($media))->keyBy('uuid');
    }

    protected function mediaData(Media $media): array
    {
        return [
            'name' => $media->name,
            'file_name' => $media->file_name,
            'uuid' => $media->uuid,
            'preview_url' => $media->hasGeneratedConversion('preview') ? $media->getUrl('preview') : '',
            'original_url' => $media->getUrl(),
            'custom_properties' => $media->custom_properties,
            'extension' => $media->extension,
            'size' => $media->size,
        ];
    }
}
