<?php

namespace Redtree\FileLibrary\Support;

use Redtree\FileLibrary\Exceptions\UnreachableUrl;

class Downloader
{
    /**
     * @throws UnreachableUrl
     */
    public function getTempFile(string $url): string
    {
        if (! $stream = @fopen($url, 'r')) {
            throw UnreachableUrl::create($url);
        }

        $temporaryFile = tempnam(sys_get_temp_dir(), 'file-library');
        file_put_contents($temporaryFile, $stream);

        return $temporaryFile;
    }
}
