<?php

namespace Redtree\FileLibrary\Http;

use Redtree\FileLibrary\Media\Models\Media;

class MediaController
{
    public function media(string $mediaUuid, string $conversionName = null)
    {
        /** @var Media $media */
        $media = Media::uuid($mediaUuid)->where('visibility', '!=', Media::VISIBILITY_CUSTOM)->first();

        if ($media === null) {
            abort(404);
        }

        if ($media->visibility === Media::VISIBILITY_PRIVATE && auth()->user() === null) {
            abort(404);
        }

        if ($conversionName !== null && $media->hasGeneratedConversion($conversionName)) {
            return $media->conversionResponse($conversionName);
        }

        return $media;
    }
}
