<?php

namespace Redtree\FileLibrary\Conversions\ImageGenerators;

use Illuminate\Support\Collection;
use Redtree\FileLibrary\Conversions\Conversion;

class Image extends ImageGenerator
{
    public function convert(string $file, Conversion $conversion = null): string
    {
        return $file;
    }

    public function requirementsAreInstalled(): bool
    {
        return true;
    }

    public function supportedExtensions(): Collection
    {
        return collect(['png', 'jpg', 'jpeg', 'gif']);
    }

    public function supportedMimeTypes(): Collection
    {
        return collect(['image/jpeg', 'image/gif', 'image/png']);
    }
}
