<?php

namespace Redtree\FileLibrary;

use Illuminate\Database\Eloquent\Relations\MorphMany;
use Redtree\FileLibrary\Conversions\Conversion;
use Redtree\FileLibrary\Media\FileAdder;
use Redtree\FileLibrary\Media\Models\Collections\MediaCollection;
use Redtree\FileLibrary\Media\Models\Media;

interface HasMedia
{
    public function media(): MorphMany;

    public function addMedia($file): FileAdder;

    public function copyMedia($file): FileAdder;

    public function hasMedia(string $collectionName): bool;

    public function getMedia(string $collectionName = 'default', $filters = []): MediaCollection;

    public function clearMediaCollection(string $collectionName = 'default'): self;

    public function clearMediaCollectionExcept(string $collectionName = 'default', $excludedMedia = []): self;

    public function shouldDeletePreservingMedia(): bool;

    public function loadMedia(string $collectionName);

    public function addMediaConversion(string $name): Conversion;

    public function registerMediaConversions(Media $media = null): void;

    public function registerMediaCollections(): void;

    public function registerAllMediaConversions(Media $media = null): void;
}
