<?php

namespace IoSession;

use Illuminate\Contracts\Container\Container;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\ServiceProvider;

class IoSessionServiceProvider extends ServiceProvider
{
    public function register() {
        Session::extend('ioSession', function (Container $app) {
            $lifetime = config('session.lifetime');
            return new IoSession($lifetime, $app);
        });
    }

    public function boot():void
    {
        $this->publishMigrations();
        $this->publishConfig();
    }

    private function publishConfig() :void
    {
        $path = $this->getConfigPath();

        $this->publishes([
            $path => config_path(),
        ], 'io-session-config');
    }

    private function publishMigrations():void
    {
        $path = $this->getMigrationsPath();
        $this->publishes([
            $path => base_path('database/migrations'),
        ], 'io-session-migrations');
    }

    private function getConfigPath():string
    {
        return __DIR__.'/../config/';
    }

    private function getMigrationsPath():string
    {
        return __DIR__.'/../migrations/';
    }

}