<?php

namespace IoSession\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;


/**
 * Class IoSession
 *
 * @property string session_id
 * @property-read string id
 * @property string app_name
 * @property string|null ip_address
 * @property string payload
 * @property string|null user_agent
 * @property Carbon last_activity
 * @method static bySessionId(string $sessionId)
 * @method static where(string $string, string $string1, Carbon $timestamp)
 * @method static createOrUpdate(array $array, array $payload)
 */
class IoSession extends Model
{
    public $timestamps = false;

    protected $table = 'io_sessions';

    protected $primaryKey = 'uuid';

    protected $fillable = [
        'uuid',
        'session_id',
        'app_name',
        'ip_address',
        'payload',
        'user_agent',
        'last_activity',
        'user_id',
    ];

    protected $dates = [
        'last_activity',
    ];

    public function user():HasOne
    {
        $this->hasOne(config('io-session'));
    }

    public function scopeBySessionId(Builder $query, $sessionId)
    {
        return $query->where('session_id', $sessionId);
    }

    protected static function booted()
    {
        parent::booted();
        static::addGlobalScope('ioapp', function (Builder $builder) {
            $builder->where('app_name', config('io-session.appName'));
        });
    }
}
