<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSessionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(! Schema::hasTable('io_sessions')) {
            Schema::create('io_sessions', function (Blueprint $table) {
                $table->uuid('uuid')->primary();
                $table->foreignId('user_id')->nullable()->index();
                $table->string('session_id')->index();
                $table->string('app_name')->index();
                $table->string('ip_address', 45)->nullable();
                $table->text('user_agent')->nullable();
                $table->text('payload');
                $table->dateTime('last_activity')->index();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('io_sessions');
    }
}
