<?php

namespace io\Settings\Commands;

use Illuminate\Console\Command;
use Illuminate\Console\GeneratorCommand;

class MakeSettingsCreatorCommand extends GeneratorCommand
{

    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'make:settings-creator';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new ioSettings generator class';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'generator';

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        $stub = '/stubs/DummyGenerator.stub';

        return __DIR__.$stub;
    }

    /**
     * Build the class with the given name.
     *
     * Remove the base controller import if we are already in base namespace.
     *
     * @param  string  $name
     * @return string
     */
    protected function buildClass($name)
    {
        $controllerNamespace = $this->getNamespace($name);

        $replace = [];

        $replace["use {$controllerNamespace};\n"] = '';

        return str_replace(
                array_keys($replace), array_values($replace), parent::buildClass($name)
            );
    }
}
