<?php

namespace io\Settings\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SettingsValue extends Model
{
    protected $table = 'settings_values';

    protected $fillable = [
        'key',
        'values',
    ];

    protected $casts = [
        'values' => 'array',
    ];

    /**
     * @return Model
     */
    public function model()
    {
        return $this->morphTo('model');
    }

    /**
     * @return BelongsTo
     */
    public function setting()
    {
        $this->belongsTo(Setting::class);
    }
}
