<?php

namespace io\Settings\Settings\Elements;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;
use Illuminate\Support\Collection;

class Tab implements Arrayable, Jsonable
{

    /**
     * @var string
     */
    private $key;

    /**
     * @var Collection
     */
    private $fields;

    /**
     * Create a new Settings Tab
     *
     * @param  string $key
     * @return void
     */
    public function __construct($key)
    {
        $this->fields = new Collection();
        $this->key = kebab_case($key);
    }

    public function addField(Field $field)
    {
        $this->fields->put($field->get('name'), $field);

        return $this;
    }

    /**
     * @return string Returns the tab key
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @return Collection
     */
    public function fields():Collection
    {
        return $this->fields;
    }

    /**
     * return Object as Array
     * @return array
     */
    public function toArray():array
    {
        return [
            'key' => $this->key,
            'fields' => $this->fields->toArray(),
        ];
    }

    /**
     * Convert the object to its JSON representation.
     *
     * @param  int  $options
     * @return string
     */
    public function toJson($options = 0):string
    {
        return json_encode($this->toArray(), $options);
    }
}
