<?php

namespace io\Settings\Settings\Elements\Fields;

use io\Settings\Settings\Elements\Field;

class SelectField extends Field
{
    /**
     * Create a new Textfield
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($name);
        $this->element('select');
        $this->set('options', []);
    }

    /**
     *  Set default value
     *
     * @param string $value
     *
     * @return self
     */
    public function addOption($key, $value):self
    {
        $options = $this->get('options', []);
        $options[$key] = $value;
        $this->set('options', $options);

        return $this;
    }

    /**
     * Remove all options from select field
     *
     * @return self
     */
    public function clearOptions():self
    {
        $this->set('options', []);

        return $this;
    }

    /**
     * @var bool $value Set field to multiple or not
     */
    public function multiple(bool $value):self
    {
        $this->remove('multiple');
        if ($value === true) {
            $this->set('multiple', $value);
        }

        return $this;
    }

    /**
     * @return bool
     */
    public function isMultiple():bool
    {
        return $this->get('multiple', false);
    }
}
