<?php

namespace io\Settings\Http\Controller;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Fluent;
use io\Settings\Routes\Routes;

class SettingsController extends Controller
{
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($modelShort, $id)
    {
        $modelClass = array_get(config('ioSettings.morphMap'), $modelShort);
        $model = with(new $modelClass())->resolveRouteBinding($id);

        $defaultSettings = $model->settings()->with(
            ['values' => function ($query) use (&$model) {
                $query->where('model_type', get_class($model))
                    ->where('model_id', $model->id);
            }]
        )->get();

        $route = Routes::routeForModel($model, 'store');
        $settings = collect();
        $defaultSettings->each(function ($setting) use (&$settings) {
            $fluent = new Fluent([
                'key' => $setting->key,
                'id' => $setting->id,
            ]);
            $fields = [];
            foreach ($setting->settings['fields'] as $key => $attributes) {
                $value = $setting->values->firstWhere('name', $key);
                if ($value) {
                    if (count($value->values) === 1) {
                        $attributes = array_merge($attributes, ['old' => array_first($value->values)]);
                    } else {
                        $attributes = array_merge($attributes, ['old' => $value->values]);
                    }
                }
                $fields[$key] = $attributes;
            }
            $fluent->fields = $fields;
            $settings->push($fluent);
        });

        return view(config('ioSettings.view'), compact('settings', 'route'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $modelShort, $id)
    {
        $modelClass = array_get(config('ioSettings.morphMap'), $modelShort);
        $model = with(new $modelClass())->resolveRouteBinding($id);

        if (! $model) {
            throw new ModelNotFoundException();
        }

        $settings = $model->settings()->find($request->get('setting_id'));

        if (! $settings) {
            throw new ModelNotFoundException();
        }

        $rules = [];
        foreach ($settings->settings['fields'] as $name => $attributes) {
            array_merge($rules, [$name => array_get($attributes, 'rules', [])]);
        }


        $validator = validator($request->all(), $rules);
        if ($validator->fails()) {
            return back(422)->withErrors($validator->errors);
        }

        foreach (array_get($settings->settings, 'fields', []) as $field => $attributes) {
            if (array_get($field, 'element') === 'select' ||
                in_array(array_get($field, 'type'), ['checkbox', 'radio'])) {
                $value = $request->get($field);
            } else {
                $value = [$request->get($field, array_get($attributes, 'value'))];
            }
            if (! $value) {
                continue;
            }
            $model->settingsValues()->updateOrCreate(
                [
                    'setting_id' => $settings->id,
                    'key' => $settings->key,
                    'name' => $field,
                ], [
                    'setting_id' => $settings->id,
                    'key' => $settings->key,
                    'name' => $field,
                    'values' => $value
                ]
            );
        }

        return back();
    }
}
