<?php

use io\Settings\Settings\Elements\Fields\SelectField;
use io\Settings\Settings\Elements\Fields\TextField;
use io\Settings\Settings\Elements\Tab;
use PHPUnit\Framework\TestCase;

class TabTest extends TestCase
{
    public function testTabIsArrayble()
    {
        $this->assertIsArray((new Tab('demo'))->toArray());
    }

    public function testNewTab()
    {
        $tabName = 'Test Tab';
        $tab = new Tab($tabName);

        $this->assertInstanceOf(Tab::class, $tab);

        $this->assertEquals(kebab_case($tabName), $tab->getKey());
    }

    public function testAddFieldsToTab()
    {
        $tabName = 'Test Add Fields Tab';
        $tab = new Tab($tabName);
        $tab->addField((new TextField('username'))
            ->placeholder('Username')
            ->label('Benutzername'))
            ->addField((new SelectField('genders'))->addOption('m', 'Male'));

        $this->assertEquals(2, $tab->fields()->count());
    }
}
