<?php

namespace io\Settings\Traits\Model;

use io\Settings\Model\SettingsValue;

trait ValueTrait
{
    /**
     * Get all settings to this class
     *
     * @return mixed
     */
    public function settingsValues(array $options = [])
    {
        return $this->morphMany(SettingsValue::class, 'model')
            ->when(
                array_has($options, 'key'), function ($query) use (&$options) {
                    $query->where('key', array_get($options, 'key'));
                }
            )
            ->when(
                array_has($options, 'name'), function ($query) use (&$options) {
                    $query->where('name', array_get($options, 'name'));
                }
            );
    }

    public function getSettingValue($key, $name)
    {
        return $this->settingsValues(compact('key', 'name'))->get();
    }
}
