@isset($settings)
    @if(is_iterable($settings))
        <ul class="nav nav-tabs" id="settingsTab" role="tablist">
            @foreach($settings as $setting)
                <li class="nav-item">
                    <a id="{{ $setting->key }}-tab" class="nav-link  @if($loop->first) active @endif" href="#{{ $setting->key }}" data-toggle="tab" role="tab" aria-controls="{{ $setting->key }}">{{ __($setting->key) }}</a>
                </li>
            @endforeach
        </ul>
        <div class="tab-content" id="settingsTabContent">
            @foreach($settings as $setting)
                <div class="tab-pane @if($loop->first) active @endif" id="{{ $setting->key }}" role="tabpanel"  aria-labelledby="{{ $setting->key }}-tab">
                    @include('iosettings::form')
                </div>
            @endforeach
        </div>
    @endif
@endisset
