# io.settings

Available for Laravel > 5.5.

This package adds setting possibility to the Laravel project. It will add 2 new tables to your database and give you the ability to add settings to any model you want. 

## Installation

Via Composer

Add this to your composer.json 

    {
      "repositories": [{
        "type": "composer",
        "url": "https://packages.redtree.de"
      }]
    }

```bash
$ composer require redtree/io.settings
```

In Laravel 5.5 the service provider will automatically get registered. In laravel versions < 5.5 you must install the service provider in your app config.

```php
// config/app.php
return [
    'providers' => [
        io\Settings\SettingsServiceProvider::class,
    ],
];

```

You must publish the provider:

```bash
php artisan vendor:publish --provider="io\Settings\SettingsServiceProvider"
```

This is the content of the published settings config. 

```php
return [
    /**
     * Config for the io.settings package.
     */

    //
    // Class that defines the Rules. These classes have to implement the SettingsCreator Contract
    // concern. Classes have to be defined with namespace
    //
    'generatorClasses' => [
        //Class => Model
    ],
    
    //
    // A mapping of Model an short Name. This is required for the url Routing in the settings.
    // Every Model defined in generatorClasses must be defined here too.
    //
    'morphMap' => [
        //'App\Post' => 'posts',
    ],


    //
    // Your default settings view
    //
    'view' => 'vendor/iosettings/settings',
];
```
It will also create new views in the vendor directory of the views path. You can change the views to your own using the config file.

After the config has been published you can create the `settings` and `settings_values` tables by running the migrations:

```bash
php artisan migrate
```

### Config

#### generatorClass

In the config file you can assign Settings to models. The key is the settings generator class and the value is the model to assign to. To generate the Settings creation class you can use artisan.

#### morphMap

The morphMap maps the models to url friendly parts. Every Model that is used in the generatorClass needs to be defined here.

#### views

This parameter is used in the SettingsController. It returning the view where the settings are use. In this view you should use `@include('ioSettings::settings')`.

### Models

Every Model that should have the ability to have settings need to imlement 2 traits. 

```php
use io\Settings\Traits\Model\SetableTrait;
use io\Settings\Traits\Model\ValueTrait;
```

The SetableTrait connects the Model with the settings class, while the ValueTrait required is for retrieving and storing the values to the model.

### Commands

This package provides 3 commands. Two make commands and one command to store the settings in the database.

#### Making a setting class

```bash
php artisan  make:settings-creator <Classname>
```

With this command a class will be created to generate the settings. All required basic implementations are done.

#### Creating settings to models

```bash
php artisan  settings:create
```

This command will create all settings you assigned in the configuration to your model. 

### Routes

Inside your routes file, you need to add the following lines:

```php
use io\Settings\Routes\Routes;
```

```php
Routes::settings();
```

This will add two routes to your application. To generate route to view settings, you can use the following function:
`Routes::routeForModel(<instance of Model>);`. This will return the settings view url. 

### Views

Nativiely this package gives you all the views you need. You can use the 
`ioSettings::settings` view. This view needs 2 parameter. The Settings Collection and a Route to store the values.

You can publish the views with the following command.

```bash
php artisan vendor:publish --provider="io\Settings\SettingsServiceProvider" --tag="ioviews"
```

## Available classes and elements

Classes:

-   io\\Settings\\Settings
-   io\\Settings\\Settings\\Elements\\Tab
-   io\\Settings\\Settings\\Elements\\Fields\\TextField
-   io\\Settings\\Settings\\Elements\\Fields\\PasswordField
-   io\\Settings\\Settings\\Elements\\Fields\\NumberField
-   io\\Settings\\Settings\\Elements\\Fields\\EmailField
-   io\\Settings\\Settings\\Elements\\Fields\\CheckboxField
-   io\\Settings\\Settings\\Elements\\Fields\\RadioButtonField
-   io\\Settings\\Settings\\Elements\\Fields\\SelectField

Each Setting can have multiple tab elements. Tabs cann be added in the settings with the `addTab` function. Each tab can have multiple fields. Everything can be added fluent. 

## Change log

Please see the [changelog](changelog.md) for more information on what has changed recently.

## Testing

```bash
$ composer test
```

## Contributing

Please see [contributing.md](contributing.md) for details and a todolist.

## Security

If you discover any security related issues, please email tech@redtree.de instead of using the issue tracker.

## Credits

-   [REDTREE GmbH][link-author]
-   [All Contributors][link-contributors]

## License

[link-author]: https://bitbucket.org/redtreegmbh/

[link-contributors]: ../../contributors
