<?php

namespace io\Settings\Model;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Setting extends Model
{
    /**
     * @var string
     */
    protected $table = 'settings';

    /**
     * @var array
     */
    protected $fillable = [
        'key',
        'settings',
        'setable_type',
        'hashsum',
    ];

    /**
     * @var array
     */
    protected $casts = [
        'settings' => 'array',
    ];

    /**
     * @return Model|Builder
     */
    public function setable()
    {
        return $this->morphTo('setable');
    }

    /**
     * @return HasMany
     */
    public function values()
    {
        return $this->hasMany(SettingsValue::class);
    }

    public function scopeValueByName($query, $name)
    {
        $query->values()->where('key', $this->key)->where('name', $name);
    }
}
