<?php

namespace io\Settings\Settings\Elements\Fields;

class EmailField extends InputField
{
    /**
     * Create a new Textfield
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($name);
        $this->type('email');
    }

    /**
     *  Set default value
     *
     * @param string $value
     *
     * @return self
     */
    public function defaultValue(string $value):self
    {
        $this->set('value', $value);

        return $this;
    }
}
