<?php

namespace io\Settings\Settings\Elements\Fields;

class TextField extends InputField
{
    /**
     * Create a new Textfield
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($name);
        $this->type('text');
    }

    /**
     * @param decimal $value
     */
    public function size(decimal $value):self
    {
        $this->set('size', $value);

        return $this;
    }

    /**
     * @param decimal $value
     */
    public function maxlength(decimal $value):self
    {
        $this->set('maxlength', $value);

        return $this;
    }
}
