<?php

namespace io\Settings\Settings\Elements\Fields;

use io\Settings\Settings\Elements\Field;

abstract class InputField extends Field
{

    /**
     * @var array
     */
    protected $allowedAttributes = [
        'autocomplete',
        'autofocus',
        'form',
        'formaction',
        'formenctype',
        'formmethod',
        'formnovalidate',
        'formtarget',
    ];

    /**
     * Create a new Textfield
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($name);
        $this->element('input');
    }

    /**
     *  Set Placeholder attribute
     *
     * @param  string  $placeholder
     *
     * @return self
     */
    public function placeholder(string $placeholder):self
    {
        $this->set('placeholder', $placeholder);

        return $this;
    }

    /**
     *  Set default value
     *
     * @param  string  $value
     *
     * @return InputField
     */
    public function defaultValue(string $value)
    {
        $this->set('value', $value);

        return $this;
    }

    /**
     * Set custom field attribute
     *
     * @param  string  $name
     * @param  mixed  $value
     * @return self
     */
    public function setCustomAttribute($name, $value):self
    {
        if (in_array($name, $this->allowedAttributes)) {
            $this->set($this->fieldcase($name), $value);
        }

        return $this;
    }
}
