<?php

namespace io\Settings\Settings\Elements\Fields;

use io\Settings\Settings\Field;

class NumberField extends Field
{
    /**
     * Create a new Textfield
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($name);
        $this->type('number');
    }

    /**
     *  Set Placeholder attribute
     *
     * @param string $placeholder
     *
     * @return self
     */
    public function placeholder(string $placeholder):self
    {
        $this->set('placeholder', $placeholder);

        return $this;
    }

    /**
     * @param decimal $value
     *
     * @return self
     */
    public function min(decimal $value):self
    {
        $this->set('min', $value);

        return $this;
    }

    /**
     * @param  decimal  $value
     * @return self
     */
    public function max(decimal $value):self
    {
        $this->set('max', $value);

        return $this;
    }

    /**
     * @param mixed $value
     *
     * @return self
     */
    public function step(decimal $value):self
    {
        $this->set('step', $value);

        return $this;
    }

    /**
     *  Set default value
     *
     * @param string $value
     *
     * @return self
     */
    public function defaultValue(string $value):self
    {
        $this->set('value', $value);

        return $this;
    }
}
