<?php

namespace io\Settings;

use Illuminate\Support\ServiceProvider;
use io\Settings\Commands\CreateSettingsCommand;
use io\Settings\Commands\MakeSettingsCreatorCommand;

class SettingsServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {

        // Config
        $this->publishes(
            [
            __DIR__.'/../config/ioSettings.php' => config_path('ioSettings.php')
            ], 'ioSetting-config'
        );

        $this->mergeConfigFrom(
            __DIR__.'/../config/ioSettings.php', 'ioSettings'
        );

        // Migrations
        $this->loadMigrationsFrom(__DIR__.'/../database');

        // Console Commands
        if ($this->app->runningInConsole()) {
            $this->commands(
                [
                CreateSettingsCommand::class,
                MakeSettingsCreatorCommand::class,
                ]
            );
        }

        //Views
        $this->loadViewsFrom(__DIR__.'/../views', 'iosettings');

        $this->publishes(
            [
            __DIR__.'/../views' => resource_path('views/vendor/iosettings')
            ], 'ioSettings-views'
        );

        $this->app->bind(
            'ioSettings', function () {
                $class = config('ioSettings.generatorClass');

                if (class_exists($class)) {
                    return (new $class())->generate();
                }

                return new Settings();
            }
        );
    }

    /**
     * Register the application services.
     */
    public function register()
    {
    }
}
