@if(array_has($field,'label'))
    <label for="{{ $setting->key }}.{{ $field['name'] }}">
        @lang(array_get($field,'label', array_get($field,'name','')))
    </label>
@endif
@if($field['type'] === 'checkbox' && filter_var( array_get($field,'is-bool', 1), FILTER_VALIDATE_BOOLEAN) === true)
    <input type="hidden" name="{{$field['name']}}" value="{{(int)!filter_var($field['value'], FILTER_VALIDATE_BOOLEAN)}}"/>
@endif
<input
    id="{{ $setting->key }}.{{ $field['name'] }}"
    type="{{ $field['type'] }}"
    name="{{ array_get($field,'name','') }}"
        @if(!in_array($field['type'],['password','checkbox']))
            value="{{ old($field['name'], array_get($field,'old')) }}"
        @elseif($field['type'] === "checkbox")
            value="{{ array_get($field,'value') }}"
            @php
                $oldOrDefault = array_get($field,'old') ?? (int) array_get($field,'checked');
                $checkedAttr = old($field['name'], $oldOrDefault ) == array_get($field,'value');
            @endphp
            {!! $checkedAttr ? 'checked==""' : '' !!}
        @endif
@foreach(array_except($field,['name','element','type','values', 'value', 'old', 'rules','is-bool','checked','position']) as $attribute => $fieldValue)
    {!! $attribute !!}="{!! $fieldValue !!}"
@endforeach
>
