<?php

namespace io\Settings\Traits\Model;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use io\Settings\Model\Setting;

trait SetableTrait
{
    /**
     * Get all settings to this class
     *
     * @return Builder
     */
    public function settings()
    {
        return Setting::where('setable_type', self::class);
    }

    /**
     * @return Collection
     */
    public function getSettingsAttribute()
    {
        return $this->settings()->get();
    }
}
