<?php

namespace io\Settings\Model;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Setting extends Model
{
    /**
     * @var string
     */
    protected $table = 'settings';

    /**
     * @var array
     */
    protected $fillable = [
        'key',
        'settings',
        'setable_type',
        'hashsum',
    ];

    /**
     * @var array
     */
    protected $casts = [
        'settings' => 'array',
    ];

    /**
     * @return MorphTo|Collection
     */
    public function setable()
    {
        return $this->morphTo('setable');
    }

    /**
     * @return HasMany|Collection
     */
    public function values()
    {
        return $this->hasMany(SettingsValue::class);
    }

    /**
     * @param  Builder  $query
     * @param  string  $name
     * @return Builder
     */
    public function scopeValueByName(Builder $query,string $name)
    {
        return $query->values()->where('key', $this->key)->where('name', $name);
    }
}
