<?php

namespace io\Settings\Settings\Elements\Fields;

use io\Settings\Settings\Elements\Field;

class TextAreaField extends Field
{
    public function __construct($name)
    {
        parent::__construct($name);
        $this->element('textarea');
    }

    /**
     * @param  int  $rows
     * @return $this
     */
    public function rows(int $rows):self
    {
        $this->set('rows', $rows);
        return $this;
    }

    /**
     * @param  int  $cols
     * @return $this
     */
    public function cols(int $cols):self
    {
        $this->set('cols', $cols);
        return $this;
    }

    /**
     * @param  int  $minlength
     * @return $this
     */
    public function minlength(int $minlength):self
    {
        $this->set('minlength', $minlength);
        return $this;
    }

    /**
     * @param  int  $maxlength
     * @return $this
     */
    public function maxlength(int $maxlength):self
    {
        $this->set('maxlength', $maxlength);
        return $this;
    }


    /**
     * @param  string  $wrap
     * @return $this
     */
    public function wrap(string $wrap):self
    {
        if(in_array($wrap, ['hard','soft'])){
            $this->set('wrap', $wrap);
        }

        return $this;
    }




}
