<?php

namespace io\Settings\Routes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Route;
use io\Settings\Http\Controller\SettingsController;

class Routes
{
    public static function settings($prefix = 'settings')
    {
        return Route::group(
            ['prefix' => $prefix], function () {
                Route::get('{model}/{id}', [SettingsController::class, 'create'])->name('io.settings.create');
                Route::post('{model}/{id}', [SettingsController::class, 'store'])->name('io.settings.store');
            }
        );
    }

    /**
     * @param  Model  $model instance of Eloquent Model
     * @param  string $type  create or store
     * @return string
     */
    public static function routeForModel(Model $model, $type = 'create'):string
    {
        $modelClass = get_class($model);
        $mapped = Arr::get(config('ioSettings.morphMap'),$modelClass);

        return route(
            'io.settings.'.$type, [
            'model' => $mapped,
            'id' => $model->getRouteKey(),
            ]
        );
    }
}
