<?php

namespace io\Settings\Settings\Elements\Fields;

use io\Settings\Settings\Field;

class RadioButtonField extends InputField
{
    /**
     * Create a new Textfield
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($name);
        $this->type('radio');
    }

    /**
     *  Set default value
     *
     * @param array $values List of Values and Labels value => Label
     *
     * @return self
     */
    public function values(array $values):self
    {
        $this->set('values', $values);

        return $this;
    }

}
