<?php

namespace io\Settings\Settings\Elements\Fields;

class CheckboxField extends InputField
{
    /**
     * Create a new Textfield
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($name);
        $this->type('checkbox');
    }

    /**
     *  Set default value
     *
     * @param string $value
     *
     * @return self
     */
    public function value(string $value):self
    {
        $this->set('value', $value);

        return $this;
    }


    /**
     * @param  bool  $isBool
     * @return self
     */
    public function isBool(bool $isBool=false):self
    {
        $this->set('is-bool',$isBool);

        return $this;
    }

    /**
     * Set field checked attribute
     *
     * @param  bool  $checked
     * @return self
     */
    public function checked(bool $checked):self
    {
        $this->set('checked', $checked);

        return $this;
    }
}
