<?php

namespace io\Settings\Settings\Elements\Fields;

class PasswordField extends InputField
{
    /**
     * Create a new Textfield
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($name);
        $this->type('password');
    }

    /**
     *
     * @param  int $value
     * @return self
     */
    public function minlength($value):self
    {
        $this->set('minlength', (int) $value);

        return $this;
    }

    /**
     *
     * @param  int $value
     * @return self
     */
    public function maxlength($value):self
    {
        $this->set('maxlength', (int) $value);

        return $this;
    }

    /**
     *
     * @param  int $value
     * @return self
     */
    public function size($value):self
    {
        $this->set('size', (int) $value);

        return $this;
    }

    /**
     *
     * @param  string $value
     * @return self
     */
    public function pattern($value):self
    {
        $this->set('pattern', $value);

        return $this;
    }
}
