<?php

//declare(strict_types=1);

use io\Settings\Settings;
use io\Settings\Settings\Elements\Tab;
use PHPUnit\Framework\TestCase;

final class SettingTest extends TestCase
{

    /**
     * @var Settings
     */
    protected $settingObject;

    /**
     * Describe me
     * @param mixed $parameters
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->settingObject = new Settings();
    }

    /**
     * Loop over settings
     */
    public function testSettingIsIterable()
    {
        $this->assertTrue(is_iterable($this->settingObject));
    }

    /**
     * Test if getting tab by name is successfull
     */
    public function testAddTabSuccess()
    {
        $name = 'Tab Add';
        $tab = new Tab($name);
        $this->settingObject->addTab($tab);

        $this->assertEquals(1, $this->settingObject->count());
    }

    /**
     * Test if getting tab by name is successfull
     */
    public function testRemoveTabSuccess()
    {
        $name = 'Tab Remove';
        $tab = new Tab($name);
        $this->settingObject->addTab($tab);

        $this->assertTrue($this->settingObject->removeTab($name));
    }

    /**
     * Test if getting tab by name is successfull
     */
    public function testGetTabSuccess()
    {
        $name = 'Test Tab';
        $tab = new Tab($name);
        $this->settingObject->addTab($tab);

        $this->assertThat($this->settingObject->getTab($name), $this->equalTo($tab));
    }

    /**
     * Retrieving Tab by name Failed
     */
    public function testAddNewTabFailed()
    {
        $name = 'testAddNewTabFailed';

        $this->assertThat($this->settingObject->getTab($name), $this->equalTo(null));
    }

    /**
     * Retrieving settings as array
     */
    public function testSettingAsArray()
    {
        $this->assertIsArray($this->settingObject->toArray());
    }
}
