<?php

namespace Redtree\Tenancy\Console\Commands\Schedules;

use Illuminate\Console\Command;
use Redtree\Tenancy\Models\System\DeployCommand;

class RunDeployCommands extends Command
{
    protected $signature = 'check:deploy-commands';

    protected $description = 'Check and run deploy commands.';

    public function handle(): int
    {
        $deployCommands = DeployCommand::query()
            ->where('app_name', config('tenancy.app_name'))
            ->get('tenant_id');

        $this->call('tenancy:deploy', ['--tenant' => $deployCommands->pluck('tenant_id')]);

        DeployCommand::where('app_name', config('tenancy.app_name'))->delete();

        return 0;
    }
}
