<?php

namespace Redtree\Tenancy\Exceptions;

use InvalidArgumentException;

class PermissionDoesNotExist extends InvalidArgumentException
{
    public static function named(string $permissionName): self
    {
        return new static(sprintf('There is no permission named `%s`.', $permissionName));
    }

    public static function withId(int $permissionId): self
    {
        return new static(sprintf('There is no [permission] with id `%s`.', $permissionId));
    }
}
