<?php

namespace Redtree\Tenancy\Exceptions;

use InvalidArgumentException;

class RoleDoesNotExist extends InvalidArgumentException
{
    public static function named(string $roleName): self
    {
        return new static(sprintf('There is no role named `%s`.', $roleName));
    }

    public static function withId(int $roleId): self
    {
        return new static(sprintf('There is no role with id `%s`.', $roleId));
    }
}
