<?php

namespace Redtree\Tenancy\Http\Controllers;

use Exception;
use Illuminate\Contracts\Auth\StatefulGuard;
use Illuminate\Http\RedirectResponse;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Log;
use OneLogin\Saml2\Auth;
use OneLogin\Saml2\Utils;
use Redtree\Tenancy\Models\System\User;

class SamlAuthController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest')->except('samlLogout');
    }

    public function samlLogin(): RedirectResponse
    {
        try {
            Utils::setProxyVars(env('APP_FORCE_SERCURE_URLS'));
            $auth = new Auth(config('saml'));
            $auth->login(redirect()->intended()->getTargetUrl());
        } catch (Exception $e) {
            Log::error($e->getMessage(), $e->getTrace());
        }

        return redirect()->away(config('saml.idp.singleSignOnService.url'));
    }

    public function samlResponse(): RedirectResponse
    {
        try {
            Utils::setProxyVars(env('APP_FORCE_SERCURE_URLS'));
            $auth = new Auth(config('saml'));
            $auth->processResponse();

            $errors = $auth->getErrors();

            if (empty($errors)) {
                $user = User::where('uuid', $auth->getAttribute('IODID'))->first();

                $this->guard()->login($user);
                session()->put('url', request()->input('RelayState'));

                return redirect()->away(request()->input('RelayState') . sprintf('?saml-login=%s', urlencode(io_encrypt(session()->getId(), request()->input('tenantUuid')))));
            }
        } catch (Exception $e) {
            Log::error($e->getMessage(), $e->getTrace());
        }

        return redirect()->away(config('saml.idp.singleSignOnService.url'));
    }

    public function samlLogout(): RedirectResponse
    {
        try {
            Utils::setProxyVars(env('APP_FORCE_SERCURE_URLS'));
            $auth = new Auth(config('saml'));
            $auth->logout(route('tenant.evu.auth.slo'), [], current_user()->email);
        } catch (Exception $e) {
            Log::error($e->getMessage(), $e->getTrace());
        }

        return redirect()->away(config('saml.idp.singleLogoutService.url'));
    }

    public function slo(): RedirectResponse
    {
        if ($this->guard()->guest()) {
            abort(404);
        }

        try {
            Utils::setProxyVars(env('APP_FORCE_SERCURE_URLS'));
            $auth = new Auth(config('saml'));
            $auth->processSLO(true);
        } catch (Exception $e) {
            return redirect()->route(config('tenancy.saml.redirectBackRoute'));
        }

        $errors = $auth->getErrors();

        if (empty($errors)) {
            $this->guard()->logout();

            session()->invalidate();
            session()->regenerateToken();

            return redirect()->away(config('saml.idp.singleSignOnService.url'));
        }

        return redirect()->route(config('tenancy.saml.redirectBackRoute'));
    }

    protected function guard(): StatefulGuard
    {
        return auth(config('tenancy.saml.guard'));
    }
}
