<?php

namespace Redtree\Tenancy\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Redtree\Tenancy\Models\System\User;

class BaseUserAuthenticated
{
    public function handle(Request $request, Closure $next)
    {
        if (config('tenancy.saml.enabled', false)) {
            $user = current_user();

            if ($user instanceof User) {
                if (! $user->is_logged_in) {
                    $request->session()->invalidate();
                    $request->session()->regenerateToken();

                    return redirect()->away(config('saml.idp.singleSignOnService.url'));
                }
            }
        }

        return $next($request);
    }
}
