<?php

namespace Redtree\Tenancy\Http\Middleware;

use Closure;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Redtree\Tenancy\Models\System\Tenant;

class InitTenant
{
    public function handle(Request $request, Closure $next)
    {
        if ($request->has('tenantUuid')) {
            $tenant = Tenant::where('uuid', $request->input('tenantUuid'))->first();
        } else {
            /** @var Tenant $tenant */
            $tenant = cache()->remember(sprintf('InitTenant.app.%s.url.%s', config('tenancy.app_name'), $request->server('HTTP_HOST')), now()->addHour(), function () use (&$request) {
                return Tenant::active()
                    ->whereHas('apps', static function (Builder $builder) use (&$request) {
                        $builder
                            ->where('is_io_app', true)
                            ->where('io_name', config('tenancy.app_name'))
                            ->where('app_tenant.url', 'like', "%{$request->server('HTTP_HOST')}%");
                    })
                    ->first();
            });
        }

        if ($tenant === null || ! $tenant->is_active) {
            abort(404);
        }

        $tenant->switchTo();

        return $next($request);
    }
}
