<?php

namespace Redtree\Tenancy\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SamlLogin
{
    public function handle(Request $request, Closure $next)
    {
        if ($request->has('saml-login')) {
            $request->session()->setId(io_decrypt($request->input('saml-login')));
            $request->session()->start();

            $url = $request->session()->get('url');
            $request->session()->forget('url');

            if ($url !== null) {
                return redirect()->to($url);
            }
        }

        return $next($request);
    }
}
